/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.emojiful;

import com.esotericsoftware.yamlbeans.YamlReader;
import com.google.gson.JsonElement;
import com.hrznstudio.emojiful.Emojiful;
import com.hrznstudio.emojiful.EmojifulConfig;
import com.hrznstudio.emojiful.api.Emoji;
import com.hrznstudio.emojiful.api.EmojiCategory;
import com.hrznstudio.emojiful.api.EmojiFromGithub;
import com.hrznstudio.emojiful.api.EmojiFromTwitmoji;
import com.hrznstudio.emojiful.datapack.EmojiRecipe;
import com.hrznstudio.emojiful.datapack.EmojiRecipeSerializer;
import com.hrznstudio.emojiful.gui.EmojiSelectionGui;
import com.hrznstudio.emojiful.gui.EmojiSuggestionHelper;
import com.hrznstudio.emojiful.render.EmojiFontRenderer;
import com.hrznstudio.emojiful.util.ProfanityFilter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientProxy {
    public static ClientProxy PROXY = new ClientProxy();
    public static Font oldFontRenderer;
    public static List<String> ALL_EMOJIS;
    public static HashMap<EmojiCategory, List<Emoji[]>> SORTED_EMOJIS_FOR_SELECTION;
    public static List<Emoji> EMOJI_WITH_TEXTS;
    public static final List<EmojiCategory> CATEGORIES;
    public static int lineAmount;
    public static EmojiSuggestionHelper emojiSuggestionHelper;
    public static EmojiSelectionGui emojiSelectionGui;

    public static void registerClient() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(PROXY::setup);
        MinecraftForge.EVENT_BUS.register((Object)PROXY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setup(FMLClientSetupEvent event) {
        this.preInitEmojis();
        this.initEmojis();
        this.indexEmojis();
        Emojiful.LOGGER.info("Loaded " + Emojiful.EMOJI_LIST.size() + " emojis");
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void guiInit(ScreenEvent.InitScreenEvent.Post event) {
        if (event.getScreen() instanceof ChatScreen && !Emojiful.error) {
            if (((Boolean)EmojifulConfig.getInstance().showEmojiAutocomplete.get()).booleanValue()) {
                emojiSuggestionHelper = new EmojiSuggestionHelper((ChatScreen)event.getScreen());
            }
            if (((Boolean)EmojifulConfig.getInstance().showEmojiSelector.get()).booleanValue()) {
                emojiSelectionGui = new EmojiSelectionGui((ChatScreen)event.getScreen());
            }
        }
    }

    private void indexEmojis() {
        ALL_EMOJIS = Emojiful.EMOJI_LIST.stream().map(emoji -> emoji.strings).flatMap(Collection::stream).collect(Collectors.toList());
        SORTED_EMOJIS_FOR_SELECTION = new LinkedHashMap<EmojiCategory, List<Emoji[]>>();
        for (EmojiCategory category : CATEGORIES) {
            ++lineAmount;
            Emoji[] array = new Emoji[9];
            int i = 0;
            Iterator iterator = ((List)Emojiful.EMOJI_MAP.getOrDefault(category.getName(), new ArrayList())).iterator();
            while (iterator.hasNext()) {
                Emoji emoji2;
                array[i] = emoji2 = (Emoji)iterator.next();
                if (++i < array.length) continue;
                SORTED_EMOJIS_FOR_SELECTION.computeIfAbsent(category, s -> new ArrayList()).add(array);
                array = new Emoji[9];
                i = 0;
                ++lineAmount;
            }
            if (i <= 0) continue;
            SORTED_EMOJIS_FOR_SELECTION.computeIfAbsent(category, s -> new ArrayList()).add(array);
            ++lineAmount;
        }
    }

    @SubscribeEvent
    public void render(ScreenEvent.DrawScreenEvent.Post event) {
        if (emojiSuggestionHelper != null) {
            emojiSuggestionHelper.render(event.getPoseStack());
        }
        if (emojiSelectionGui != null) {
            emojiSelectionGui.m_94757_(event.getMouseX(), event.getMouseY());
            emojiSelectionGui.render(event.getPoseStack());
        }
    }

    @SubscribeEvent
    public void onKeyPressed(ScreenEvent.KeyboardKeyPressedEvent event) {
        if (emojiSuggestionHelper != null && emojiSuggestionHelper.m_7933_(event.getKeyCode(), event.getScanCode(), event.getModifiers())) {
            event.setCanceled(true);
        }
        if (emojiSelectionGui != null && emojiSelectionGui.m_7933_(event.getKeyCode(), event.getScanCode(), event.getModifiers())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onClick(ScreenEvent.MouseClickedEvent.Pre event) {
        if (emojiSelectionGui != null) {
            emojiSelectionGui.m_6375_(event.getMouseX(), event.getMouseY(), event.getButton());
        }
    }

    @SubscribeEvent
    public void onScroll(ScreenEvent.MouseScrollEvent.Pre event) {
        if (emojiSelectionGui != null) {
            emojiSelectionGui.m_6050_(event.getMouseX(), event.getMouseY(), event.getScrollDelta());
        }
    }

    @SubscribeEvent
    public void onClose(TickEvent.ClientTickEvent event) {
        if (emojiSelectionGui != null && Minecraft.m_91087_().f_91080_ != emojiSelectionGui.getChatScreen()) {
            emojiSelectionGui = null;
        }
    }

    @SubscribeEvent
    public void onCharTyped(ScreenEvent.KeyboardCharTypedEvent event) {
        if (emojiSelectionGui != null && emojiSelectionGui.m_5534_(event.getCodePoint(), event.getModifiers())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onChatRecieved(ClientChatReceivedEvent event) {
        if (((Boolean)EmojifulConfig.getInstance().profanityFilter.get()).booleanValue() && event.getMessage() instanceof TranslatableComponent && ((TranslatableComponent)event.getMessage()).m_131328_().equals("chat.type.text")) {
            BaseComponent component = (BaseComponent)((TranslatableComponent)event.getMessage()).m_131329_()[1];
            TranslatableComponent translationTextComponent = new TranslatableComponent("chat.type.text", new Object[]{((TranslatableComponent)event.getMessage()).m_131329_()[0], ForgeHooks.newChatWithLinks((String)ProfanityFilter.filterText(component.getString()))});
            event.setMessage((Component)translationTextComponent);
        }
    }

    @SubscribeEvent
    public void onChatSend(ClientChatEvent event) {
        if (((Boolean)EmojifulConfig.getInstance().renderEmoji.get()).booleanValue() && ((Boolean)EmojifulConfig.getInstance().shortEmojiReplacement.get()).booleanValue()) {
            String message = event.getMessage();
            for (Emoji emoji : EMOJI_WITH_TEXTS) {
                if (emoji.texts.size() <= 0) continue;
                message = message.replaceAll(emoji.getTextRegex(), emoji.getShorterString());
            }
            event.setMessage(message);
        }
    }

    @SubscribeEvent
    public void onRecipesUpdated(RecipesUpdatedEvent event) {
        CATEGORIES.removeIf(EmojiCategory::isWorldBased);
        Emojiful.EMOJI_LIST.removeIf(emoji -> emoji.worldBased);
        Emojiful.EMOJI_MAP.values().forEach(emojis -> emojis.removeIf(emoji -> emoji.worldBased));
        if (((Boolean)EmojifulConfig.getInstance().loadDatapack.get()).booleanValue()) {
            for (EmojiRecipe emojiRecipe : event.getRecipeManager().m_44013_(EmojiRecipeSerializer.EMOJI_RECIPE_SERIALIZER.recipeType)) {
                EmojiFromGithub emoji2 = new EmojiFromGithub();
                emoji2.name = emojiRecipe.getName();
                emoji2.strings = new ArrayList();
                emoji2.strings.add(":" + emojiRecipe.getName() + ":");
                emoji2.location = emojiRecipe.getName();
                emoji2.url = emojiRecipe.getUrl();
                emoji2.worldBased = true;
                System.out.println(emoji2.getUrl());
                Emojiful.EMOJI_MAP.computeIfAbsent(emojiRecipe.getCategory(), s -> new ArrayList()).add(emoji2);
                Emojiful.EMOJI_LIST.add(emoji2);
                if (!CATEGORIES.stream().noneMatch(emojiCategory -> emojiCategory.getName().equalsIgnoreCase(emojiRecipe.getCategory()))) continue;
                CATEGORIES.add(0, new EmojiCategory(emojiRecipe.getCategory(), true));
            }
            this.indexEmojis();
        }
    }

    private void preInitEmojis() {
        CATEGORIES.addAll(Arrays.asList("Smileys & Emotion", "Animals & Nature", "Food & Drink", "Activities", "Travel & Places", "Objects", "Symbols", "Flags").stream().map(s -> new EmojiCategory((String)s, false)).collect(Collectors.toList()));
        if (((Boolean)EmojifulConfig.getInstance().loadCustom.get()).booleanValue()) {
            this.loadCustomEmojis();
        }
        if (((Boolean)EmojifulConfig.getInstance().loadTwemoji.get()).booleanValue()) {
            this.loadTwemojis();
        }
        if (((Boolean)EmojifulConfig.getInstance().profanityFilter.get()).booleanValue()) {
            ProfanityFilter.loadConfigs();
        }
    }

    private void loadCustomEmojis() {
        try {
            YamlReader reader = new YamlReader(new StringReader(Emojiful.readStringFromURL("https://raw.githubusercontent.com/InnovativeOnlineIndustries/emojiful-assets/master/Categories.yml")));
            ArrayList categories = (ArrayList)reader.read();
            for (String category : categories) {
                CATEGORIES.add(0, new EmojiCategory(category.replace(".yml", ""), false));
                List<Emoji> emojis = Emojiful.readCategory(category);
                Emojiful.EMOJI_LIST.addAll(emojis);
                Emojiful.EMOJI_MAP.put(category.replace(".yml", ""), emojis);
            }
        }
        catch (Exception e) {
            Emojiful.error = true;
            Emojiful.LOGGER.catching((Throwable)e);
        }
    }

    private void loadApiEmojis() {
        for (JsonElement categories : Emojiful.readJsonFromUrl("https://www.emojidex.com/api/v1/categories").getAsJsonObject().getAsJsonArray("categories")) {
            Emojiful.EMOJI_MAP.put(categories.getAsJsonObject().get("code").getAsString(), new ArrayList());
        }
    }

    public void loadGithubEmojis() {
        Emojiful.EMOJI_MAP.put("Github", new ArrayList());
        for (Map.Entry entry : Emojiful.readJsonFromUrl("https://api.github.com/emojis").getAsJsonObject().entrySet()) {
            EmojiFromGithub emoji = new EmojiFromGithub();
            emoji.name = (String)entry.getKey();
            emoji.strings = new ArrayList();
            emoji.strings.add(":" + (String)entry.getKey() + ":");
            emoji.location = (String)entry.getKey();
            emoji.url = ((JsonElement)entry.getValue()).getAsString();
            Emojiful.EMOJI_MAP.get("Github").add(emoji);
            Emojiful.EMOJI_LIST.add(emoji);
        }
    }

    public void loadTwemojis() {
        try {
            for (JsonElement element : Emojiful.readJsonFromUrl("https://raw.githubusercontent.com/iamcal/emoji-data/master/emoji.json").getAsJsonArray()) {
                if (!element.getAsJsonObject().get("has_img_twitter").getAsBoolean()) continue;
                EmojiFromTwitmoji emoji = new EmojiFromTwitmoji();
                emoji.name = element.getAsJsonObject().get("short_name").getAsString();
                emoji.location = element.getAsJsonObject().get("image").getAsString();
                emoji.sort = element.getAsJsonObject().get("sort_order").getAsInt();
                element.getAsJsonObject().get("short_names").getAsJsonArray().forEach(jsonElement -> emoji.strings.add(":" + jsonElement.getAsString() + ":"));
                if (emoji.strings.contains(":face_with_symbols_on_mouth:")) {
                    emoji.strings.add(":swear:");
                }
                if (!element.getAsJsonObject().get("texts").isJsonNull()) {
                    element.getAsJsonObject().get("texts").getAsJsonArray().forEach(jsonElement -> emoji.texts.add(jsonElement.getAsString()));
                }
                Emojiful.EMOJI_MAP.computeIfAbsent(element.getAsJsonObject().get("category").getAsString(), s -> new ArrayList()).add(emoji);
                Emojiful.EMOJI_LIST.add(emoji);
                if (emoji.texts.size() <= 0) continue;
                EMOJI_WITH_TEXTS.add(emoji);
            }
            EMOJI_WITH_TEXTS.sort(Comparator.comparingInt(o -> o.sort));
            Emojiful.EMOJI_MAP.values().forEach(emojis -> emojis.sort(Comparator.comparingInt(o -> o.sort)));
        }
        catch (Exception e) {
            Emojiful.error = true;
            Emojiful.LOGGER.catching((Throwable)e);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void initEmojis() {
        if (!Emojiful.error) {
            oldFontRenderer = Minecraft.m_91087_().f_91062_;
            Minecraft.m_91087_().m_91290_().f_114365_ = Minecraft.m_91087_().f_91062_ = new EmojiFontRenderer(Minecraft.m_91087_().f_91062_);
            BlockEntityRenderers.m_173590_((BlockEntityType)BlockEntityType.f_58924_, p_173571_ -> {
                SignRenderer signRenderer = new SignRenderer(p_173571_);
                signRenderer.f_173633_ = Minecraft.m_91087_().f_91062_;
                return signRenderer;
            });
        }
    }

    static {
        ALL_EMOJIS = new ArrayList<String>();
        SORTED_EMOJIS_FOR_SELECTION = new LinkedHashMap<EmojiCategory, List<Emoji[]>>();
        EMOJI_WITH_TEXTS = new ArrayList<Emoji>();
        CATEGORIES = new ArrayList<EmojiCategory>();
    }
}

